# WP Business Directory

A comprehensive business directory plugin for WordPress with category filtering, user management, and frontend dashboard.

## Features

- **Business Directory Block**: Display business listings with category filtering and breadcrumbs
- **User Dashboard Block**: Allow users to login/register and manage their business listings from the frontend
- **Admin Approval System**: Administrators must approve users before they can submit listings
- **Listing Limitations**: Set limits on how many listings each user can submit
- **Business Listings**: Each listing includes:
  - Logo
  - Business Name
  - Description (limited to 150 characters)
  - Phone Number
  - Address
  - Website

## Installation

1. Upload the plugin files to the `/wp-content/plugins/wp-business-directory` directory
2. Activate the plugin through the 'Plugins' screen in WordPress
3. Use the WP Business Directory blocks in your pages

## Usage

### Directory Block
Add the "Business Directory" block to any page to display the directory with category filtering.

### User Dashboard Block
Add the "User Dashboard" block to any page to allow users to:
- Register for an account
- Login to their account
- Submit business listings (after admin approval)
- Manage their existing listings

### Admin Management
As an administrator, you can:
- Manage business categories
- Approve/reject user registrations
- Set listing limits per user
- Review and approve business listings
- Edit all business listings

## Requirements

- WordPress 5.0 or higher
- PHP 7.0 or higher

## Changelog

### 1.0.0
- Initial release
