(function(wp) {
    var el = wp.element.createElement;
    var __ = wp.i18n.__;
    var registerBlockType = wp.blocks.registerBlockType;
    var InspectorControls = wp.blockEditor.InspectorControls;
    var PanelBody = wp.components.PanelBody;
    var ToggleControl = wp.components.ToggleControl;
    var RangeControl = wp.components.RangeControl;
    
    // Register directory block
    registerBlockType('wp-business-directory/directory-block', {
        title: __('Business Directory', 'wp-business-directory'),
        description: __('Display the business directory with category filtering.', 'wp-business-directory'),
        category: 'widgets',
        icon: 'store',
        supports: {
            html: false,
        },
        attributes: {
            showCategories: {
                type: 'boolean',
                default: true,
            },
            postsPerPage: {
                type: 'number',
                default: 10,
            }
        },
        edit: function(props) {
            var attributes = props.attributes;
            var setAttributes = props.setAttributes;
            
            return [
                el('div', { className: props.className },
                    el('div', { className: 'wpbd-directory-block-preview' },
                        el('h3', {}, __('Business Directory Preview', 'wp-business-directory')),
                        el('p', {}, __('This block will display business categories and listings.', 'wp-business-directory'))
                    )
                ),
                el(InspectorControls, {},
                    el(PanelBody, { title: __('Directory Settings', 'wp-business-directory'), initialOpen: true },
                        el(ToggleControl, {
                            label: __('Show Categories', 'wp-business-directory'),
                            checked: attributes.showCategories,
                            onChange: function(value) {
                                setAttributes({ showCategories: value });
                            }
                        }),
                        el(RangeControl, {
                            label: __('Listings per Page', 'wp-business-directory'),
                            value: attributes.postsPerPage,
                            onChange: function(value) {
                                setAttributes({ postsPerPage: value });
                            },
                            min: 1,
                            max: 50
                        })
                    )
                )
            ];
        },
        save: function() {
            // Rendering is done in PHP
            return null;
        },
    });
    
    // Register user dashboard block
    registerBlockType('wp-business-directory/user-dashboard-block', {
        title: __('User Dashboard', 'wp-business-directory'),
        description: __('Allow users to login/register and manage their business listings.', 'wp-business-directory'),
        category: 'widgets',
        icon: 'admin-users',
        supports: {
            html: false,
        },
        attributes: {
            showLogin: {
                type: 'boolean',
                default: true,
            }
        },
        edit: function(props) {
            var attributes = props.attributes;
            var setAttributes = props.setAttributes;
            
            return [
                el('div', { className: props.className },
                    el('div', { className: 'wpbd-dashboard-block-preview' },
                        el('h3', {}, __('User Dashboard Preview', 'wp-business-directory')),
                        el('p', {}, __('This block will display login/registration form for users and their dashboard.', 'wp-business-directory'))
                    )
                ),
                el(InspectorControls, {},
                    el(PanelBody, { title: __('Dashboard Settings', 'wp-business-directory'), initialOpen: true },
                        el(ToggleControl, {
                            label: __('Show Login Form', 'wp-business-directory'),
                            checked: attributes.showLogin,
                            onChange: function(value) {
                                setAttributes({ showLogin: value });
                            }
                        })
                    )
                )
            ];
        },
        save: function() {
            // Rendering is done in PHP
            return null;
        },
    });
})(window.wp);
