jQuery(document).ready(function ($) {
    // Category filtering
    $('.wpbd-category-link').on('click', function (e) {
        e.preventDefault();

        var categoryId = $(this).data('category');

        $.ajax({
            url: wpbd_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'wpbd_load_category_listings',
                category_id: categoryId,
                page: 1,
                nonce: wpbd_ajax.nonce
            },
            success: function (response) {
                if (response.success) {
                    // Update breadcrumbs
                    var categoryName = $('.wpbd-category-link[data-category="' + categoryId + '"]').text();
                    $('.wpbd-breadcrumbs').html('<a href="#" class="wpbd-home-link">' + wpbd_ajax.home + '</a> > ' + categoryName);

                    // Hide featured listings and categories, show listings
                    $('.wpbd-featured-listings').hide();
                    $('.wpbd-categories').hide();
                    $('.wpbd-listings').html(response.data.html).show();
                }
            }
        });
    });

    // Tab switching for login/register
    $('.wpbd-tab-link').on('click', function () {
        var tab = $(this).data('tab');

        $('.wpbd-tab-link').removeClass('active');
        $(this).addClass('active');

        $('.wpbd-tab-content').removeClass('active');
        $('#wpbd-' + tab + '-tab').addClass('active');
    });

    // Show add business form
    $('#wpbd-show-add-form').on('click', function () {
        $('#wpbd-add-business-form').show();
        $(this).hide();
    });

    // Cancel add business form
    $('#wpbd-cancel-form').on('click', function () {
        // Reset form
        $('#wpbd-business-form')[0].reset();

        // Reset form title and button text
        $('#form-title').text('Add New Business Listing');
        $('#submit-button-text').text('Submit Listing');
        $('#wpbd-post-id').val('');

        // Hide form
        $('#wpbd-add-business-form').hide();
        $('#wpbd-show-add-form').show();
    });

    // Submit business form
    $('#wpbd-business-form').on('submit', function (e) {
        e.preventDefault();

        var formData = new FormData(this);
        formData.append('action', 'wpbd_submit_business');
        formData.append('nonce', wpbd_ajax.nonce);

        $.ajax({
            url: wpbd_ajax.ajax_url,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                if (response.success) {
                    alert(response.data);
                    $('#wpbd-business-form')[0].reset();
                    $('#wpbd-add-business-form').hide();
                    $('#wpbd-show-add-form').show();
                    loadUserBusinesses();
                } else {
                    alert(response.data);
                }
            },
            error: function () {
                alert('An error occurred. Please try again.');
            }
        });
    });

    // Load user businesses on dashboard load
    if ($('#wpbd-user-dashboard').length) {
        loadUserBusinesses();
    }

    function loadUserBusinesses() {
        $.ajax({
            url: wpbd_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'wpbd_get_user_businesses',
                nonce: wpbd_ajax.nonce
            },
            success: function (response) {
                if (response.success) {
                    var html = '';
                    if (response.data.length > 0) {
                        html += '<div class="wpbd-business-list">';
                        $.each(response.data, function (index, business) {
                            var statusClass = 'wpbd-business-item';
                            if (business.status === 'pending') {
                                statusClass += ' wpbd-business-item-pending';
                            }

                            html += '<div class="' + statusClass + '">';
                            html += '<div class="wpbd-business-item-info">';
                            html += '<strong>' + business.title + '</strong>';
                            html += '</div>';
                            html += '<div class="wpbd-business-item-actions">';
                            html += '<button class="wpbd-edit-button wpbd-button wpbd-button-secondary" data-id="' + business.ID + '">Edit</button> ';
                            html += '<button class="wpbd-delete-button" data-id="' + business.ID + '">Delete</button>';
                            html += '</div>';
                            html += '</div>';
                        });
                        html += '</div>';
                    } else {
                        html = '<p>You have not submitted any business listings yet.</p>';
                    }

                    $('#wpbd-business-list').html(html);
                }
            }
        });
    }

    // Edit business
    $(document).on('click', '.wpbd-edit-button', function () {
        var postId = $(this).data('id');

        // Load business data
        $.ajax({
            url: wpbd_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'wpbd_get_business_data',
                post_id: postId,
                nonce: wpbd_ajax.nonce
            },
            success: function (response) {
                if (response.success) {
                    var data = response.data;

                    // Populate form with existing data
                    $('#wpbd-post-id').val(data.ID);
                    $('#wpbd-business-name').val(data.title);
                    $('#wpbd-description').val(data.description);
                    $('#wpbd-phone').val(data.phone);
                    $('#wpbd-address').val(data.address);
                    $('#wpbd-website').val(data.website);

                    // Clear categories and select existing ones
                    $('#wpbd-categories').val(null);
                    if (data.categories) {
                        $('#wpbd-categories').val(data.categories);
                    }

                    // Update form title and button text
                    $('#form-title').text('Edit Business Listing');
                    $('#submit-button-text').text('Update Listing');

                    // Show form
                    $('#wpbd-add-business-form').show();
                    $('#wpbd-show-add-form').hide();
                }
            }
        });
    });

    // Delete business
    $(document).on('click', '.wpbd-delete-button', function () {
        if (confirm('Are you sure you want to delete this business listing?')) {
            var postId = $(this).data('id');

            $.ajax({
                url: wpbd_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'wpbd_delete_business',
                    post_id: postId,
                    nonce: wpbd_ajax.nonce
                },
                success: function (response) {
                    if (response.success) {
                        alert(response.data);
                        loadUserBusinesses();
                    } else {
                        alert(response.data);
                    }
                }
            });
        }
    });

    // Login form
    $('#wpbd-login-form').on('submit', function (e) {
        e.preventDefault();

        var username = $('#wpbd-login-username').val();
        var password = $('#wpbd-login-password').val();

        $.ajax({
            url: wpbd_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'wpbd_login',
                username: username,
                password: password,
                nonce: wpbd_ajax.nonce
            },
            success: function (response) {
                if (response.success) {
                    window.location.reload();
                } else {
                    alert(response.data);
                }
            }
        });
    });

    // Register form
    $('#wpbd-register-form').on('submit', function (e) {
        e.preventDefault();

        var username = $('#wpbd-register-username').val();
        var email = $('#wpbd-register-email').val();
        var password = $('#wpbd-register-password').val();
        var confirmPassword = $('#wpbd-register-confirm-password').val();

        if (password !== confirmPassword) {
            alert('Passwords do not match.');
            return;
        }

        $.ajax({
            url: wpbd_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'wpbd_register',
                username: username,
                email: email,
                password: password,
                nonce: wpbd_ajax.nonce
            },
            success: function (response) {
                if (response.success) {
                    alert('Registration successful! Please wait for administrator approval.');
                    $('#wpbd-register-form')[0].reset();
                    $('.wpbd-tab-link[data-tab="login"]').click();
                } else {
                    alert(response.data);
                }
            }
        });
    });

    // Home link in breadcrumbs
    $(document).on('click', '.wpbd-home-link', function (e) {
        e.preventDefault();

        // Show featured listings and categories, hide regular listings
        $('.wpbd-featured-listings').show();
        $('.wpbd-categories').show();
        $('.wpbd-listings').empty().hide();

        // Reset breadcrumbs
        $('.wpbd-breadcrumbs').html('<a href="' + window.location.href + '">' + wpbd_ajax.home + '</a>');
    });

    // Accordion functionality
    $('.wpbd-accordion-toggle').on('click', function (e) {
        e.preventDefault();
        var $toggle = $(this);
        var $content = $toggle.closest('li').find('> .wpbd-accordion-content');

        $toggle.attr('aria-expanded', $toggle.attr('aria-expanded') === 'true' ? 'false' : 'true');
        $content.slideToggle();
        $toggle.find('.dashicons').toggleClass('dashicons-arrow-down-alt2 dashicons-arrow-up-alt2');
    });

    // Search functionality
    var searchTimeout;
    $('#wpbd-search-input').on('keyup', function () {
        var searchTerm = $(this).val();
        var $resultsContainer = $('#wpbd-search-results');

        clearTimeout(searchTimeout);

        if (searchTerm.length < 2) {
            $resultsContainer.hide();
            return;
        }

        searchTimeout = setTimeout(function () {
            $.ajax({
                url: wpbd_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'wpbd_search_listings',
                    search_term: searchTerm,
                    nonce: wpbd_ajax.nonce
                },
                success: function (response) {
                    if (response.success) {
                        var results = response.data.results;
                        var html = '';

                        if (results.length > 0) {
                            html += '<ul class="wpbd-autocomplete-list">';

                            // Group results
                            var categories = results.filter(function (item) { return item.type === 'category'; });
                            var businesses = results.filter(function (item) { return item.type === 'business'; });

                            if (categories.length > 0) {
                                html += '<li class="wpbd-autocomplete-header">Categories</li>';
                                $.each(categories, function (index, item) {
                                    html += '<li class="wpbd-autocomplete-item" data-id="' + item.id + '" data-type="' + item.type + '">';
                                    html += '<div class="wpbd-item-title">' + item.title + '</div>';
                                    html += '</li>';
                                });
                            }

                            if (businesses.length > 0) {
                                html += '<li class="wpbd-autocomplete-header">Businesses</li>';
                                $.each(businesses, function (index, item) {
                                    html += '<li class="wpbd-autocomplete-item" data-id="' + item.id + '" data-type="' + item.type + '">';
                                    html += '<div class="wpbd-item-title">' + item.title + '</div>';
                                    if (item.subtitle && item.subtitle !== 'Business') {
                                        html += '<div class="wpbd-item-subtitle">' + item.subtitle + '</div>';
                                    }
                                    html += '</li>';
                                });
                            }

                            html += '</ul>';
                            $resultsContainer.html(html).show();
                        } else {
                            $resultsContainer.html('<div class="wpbd-no-results">No results found</div>').show();
                        }
                    }
                }
            });
        }, 300);
    });
    // Handle click on autocomplete item
    $(document).on('click', '.wpbd-autocomplete-item', function () {
        var id = $(this).data('id');
        var type = $(this).data('type');
        var $resultsContainer = $('#wpbd-search-results');

        $('#wpbd-search-input').val($(this).find('.wpbd-item-title').text());
        $resultsContainer.hide();

        if (type === 'category') {
            // Load category listings
            // We need to trigger the category load. 
            // Since the function isn't global, we can trigger a click on the category link if it exists, 
            // or we need to expose the loader.
            // But wait, the category links use a data attribute.
            // Let's just trigger a click on a hidden link or call the ajax directly if we can.
            // Actually, let's just use the existing AJAX call logic.
            // But we need to update the breadcrumbs and hide categories etc.
            // The easiest way is to find the category link in the accordion and click it.
            var $catLink = $('.wpbd-category-link[data-category="' + id + '"]');
            if ($catLink.length) {
                $catLink.click();
            } else {
                // Fallback if link not found (e.g. hidden)
                // We can just reload the page with ?category=id or implement the ajax call here.
                // Let's implement the ajax call here to be safe.
                $.ajax({
                    url: wpbd_ajax.ajax_url,
                    type: 'POST',
                    data: {
                        action: 'wpbd_load_category_listings',
                        category_id: id,
                        page: 1,
                        nonce: wpbd_ajax.nonce
                    },
                    success: function (response) {
                        if (response.success) {
                            // Update breadcrumbs (simplified)
                            $('.wpbd-breadcrumbs').html('<a href="' + window.location.href.split('?')[0] + '">' + wpbd_ajax.home + '</a> > ' + $('#wpbd-search-input').val());

                            // Hide categories and show listings
                            $('.wpbd-categories').hide();
                            $('.wpbd-featured-listings').hide();
                            $('.wpbd-listings').html(response.data.html).show();
                        }
                    }
                });
            }
        } else if (type === 'business') {
            $.ajax({
                url: wpbd_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'wpbd_get_business_html',
                    business_id: id,
                    nonce: wpbd_ajax.nonce
                },
                success: function (response) {
                    if (response.success) {
                        $('.wpbd-listings').html(response.data.html).show();
                        $('.wpbd-featured-listings').hide();
                        $('.wpbd-categories').hide();
                    }
                }
            });
        }
    });

    // Handle category click from search results
    $(document).on('click', '.wpbd-search-result[data-type="category"]', function () {
        var categoryId = $(this).data('id');
        $('#wpbd-search-input').val('');
        $('#wpbd-search-results').hide();

        $.ajax({
            url: wpbd_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'wpbd_load_category_listings',
                category_id: categoryId,
                page: 1,
                nonce: wpbd_ajax.nonce
            },
            success: function (response) {
                if (response.success) {
                    var categoryName = $('.wpbd-category-link[data-category="' + categoryId + '"]').text() || 'Category';
                    $('.wpbd-breadcrumbs').html('<a href="#" class="wpbd-home-link">' + wpbd_ajax.home + '</a> > ' + categoryName);

                    // Hide featured listings and categories, show listings
                    $('.wpbd-featured-listings').hide();
                    $('.wpbd-categories').hide();
                    $('.wpbd-listings').html(response.data.html).show();
                }
            }
        });
    });

    // Handle business click from search results
    $(document).on('click', '.wpbd-search-result[data-type="business"]', function () {
        var businessId = $(this).data('id');
        $('#wpbd-search-input').val('');
        $('#wpbd-search-results').hide();

        $.ajax({
            url: wpbd_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'wpbd_get_business_html',
                business_id: businessId,
                nonce: wpbd_ajax.nonce
            },
            success: function (response) {
                if (response.success) {
                    // Hide featured listings and categories, show single business
                    $('.wpbd-featured-listings').hide();
                    $('.wpbd-categories').hide();
                    $('.wpbd-listings').html(response.data.html).show();
                    $('.wpbd-breadcrumbs').html('<a href="#" class="wpbd-home-link">' + wpbd_ajax.home + '</a> > Business');
                }
            }
        });
    });

    // Close search results when clicking outside
    $(document).on('click', function (e) {
        if (!$(e.target).closest('.wpbd-search-container').length) {
            $('#wpbd-search-results').hide();
        }
    });

    // Search button click
    $('#wpbd-search-button').on('click', function () {
        var searchTerm = $('#wpbd-search-input').val();
        if (searchTerm.length >= 2) {
            $('#wpbd-search-input').trigger('keyup');
        } else {
            $('#wpbd-search-input').focus();
        }
    });

});
