<?php
/**
 * Core plugin functionality
 */

if (!defined('ABSPATH')) {
    exit;
}

class WPBD_Core
{

    public function __construct()
    {
        // Hook into WordPress
        add_action('init', array($this, 'register_post_types'));
        add_action('init', array($this, 'register_taxonomies'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));
        add_action('admin_enqueue_scripts', array($this, 'admin_enqueue_scripts'));

        // Register blocks
        add_action('init', array($this, 'register_blocks'));
    }

    /**
     * Register custom post types
     */
    public function register_post_types()
    {
        // Business Listing Post Type
        $business_args = array(
            'labels' => array(
                'name' => __('Business Listings', 'wp-business-directory'),
                'singular_name' => __('Business Listing', 'wp-business-directory'),
                'menu_name' => __('Business Directory', 'wp-business-directory'),
                'name_admin_bar' => __('Business Listing', 'wp-business-directory'),
                'archives' => __('Business Listing Archives', 'wp-business-directory'),
                'attributes' => __('Business Listing Attributes', 'wp-business-directory'),
                'parent_item_colon' => __('Parent Business Listing:', 'wp-business-directory'),
                'all_items' => __('All Business Listings', 'wp-business-directory'),
                'add_new_item' => __('Add New Business Listing', 'wp-business-directory'),
                'add_new' => __('Add New', 'wp-business-directory'),
                'new_item' => __('New Business Listing', 'wp-business-directory'),
                'edit_item' => __('Edit Business Listing', 'wp-business-directory'),
                'update_item' => __('Update Business Listing', 'wp-business-directory'),
                'view_item' => __('View Business Listing', 'wp-business-directory'),
                'view_items' => __('View Business Listings', 'wp-business-directory'),
                'search_items' => __('Search Business Listing', 'wp-business-directory'),
                'not_found' => __('Not found', 'wp-business-directory'),
                'not_found_in_trash' => __('Not found in Trash', 'wp-business-directory'),
            ),
            'public' => true,
            'publicly_queryable' => true,
            'show_ui' => true,
            'show_in_menu' => true,
            'query_var' => true,
            'rewrite' => array('slug' => 'business-listing'),
            'capability_type' => 'post',
            'has_archive' => true,
            'hierarchical' => false,
            'menu_position' => null,
            'menu_icon' => 'dashicons-store',
            'supports' => array('title', 'editor', 'thumbnail', 'custom-fields'),
            'show_in_rest' => true,
        );

        register_post_type('wpbd_business', $business_args);
    }

    /**
     * Register custom taxonomies
     */
    public function register_taxonomies()
    {
        // Business Category Taxonomy
        $category_args = array(
            'labels' => array(
                'name' => __('Business Categories', 'wp-business-directory'),
                'singular_name' => __('Business Category', 'wp-business-directory'),
                'menu_name' => __('Categories', 'wp-business-directory'),
                'all_items' => __('All Categories', 'wp-business-directory'),
                'parent_item' => __('Parent Category', 'wp-business-directory'),
                'parent_item_colon' => __('Parent Category:', 'wp-business-directory'),
                'new_item_name' => __('New Category Name', 'wp-business-directory'),
                'add_new_item' => __('Add New Category', 'wp-business-directory'),
                'edit_item' => __('Edit Category', 'wp-business-directory'),
                'update_item' => __('Update Category', 'wp-business-directory'),
                'view_item' => __('View Category', 'wp-business-directory'),
                'separate_items_with_commas' => __('Separate categories with commas', 'wp-business-directory'),
                'add_or_remove_items' => __('Add or remove categories', 'wp-business-directory'),
                'choose_from_most_used' => __('Choose from the most used', 'wp-business-directory'),
                'popular_items' => __('Popular Categories', 'wp-business-directory'),
                'search_items' => __('Search Categories', 'wp-business-directory'),
                'not_found' => __('Not Found', 'wp-business-directory'),
                'no_terms' => __('No categories', 'wp-business-directory'),
                'items_list' => __('Categories list', 'wp-business-directory'),
                'items_list_navigation' => __('Categories list navigation', 'wp-business-directory'),
            ),
            'hierarchical' => true,
            'public' => true,
            'show_ui' => true,
            'show_admin_column' => true,
            'show_in_nav_menus' => true,
            'show_tagcloud' => true,
            'show_in_rest' => true,
            'rewrite' => array('slug' => 'business-category'),
        );

        register_taxonomy('wpbd_category', array('wpbd_business'), $category_args);
    }

    /**
     * Enqueue public scripts and styles
     */
    public function enqueue_scripts()
    {
        wp_enqueue_style(
            'wpbd-public-css',
            WPBD_PLUGIN_URL . 'assets/css/public.css',
            array(),
            WPBD_VERSION
        );

        // Add custom CSS if it exists
        $custom_css = get_option('wpbd_custom_css', '');
        if (!empty($custom_css)) {
            wp_add_inline_style('wpbd-public-css', $custom_css);
        }

        wp_enqueue_script(
            'wpbd-public-js',
            WPBD_PLUGIN_URL . 'assets/js/public.js',
            array('jquery'),
            WPBD_VERSION,
            true
        );

        wp_localize_script('wpbd-public-js', 'wpbd_ajax', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('wpbd_nonce'),
            'home' => __('Home', 'wp-business-directory')
        ));
    }

    /**
     * Enqueue admin scripts and styles
     */
    public function admin_enqueue_scripts()
    {
        wp_enqueue_style(
            'wpbd-admin-css',
            WPBD_PLUGIN_URL . 'assets/css/admin.css',
            array(),
            WPBD_VERSION
        );

        wp_enqueue_script(
            'wpbd-admin-js',
            WPBD_PLUGIN_URL . 'assets/js/admin.js',
            array('jquery'),
            WPBD_VERSION,
            true
        );
    }

    /**
     * Register Gutenberg blocks
     */
    public function register_blocks()
    {
        // Directory block
        register_block_type('wp-business-directory/directory-block', array(
            'editor_script' => 'wpbd-blocks-js',
            'editor_style' => 'wpbd-blocks-css',
            'render_callback' => array($this, 'render_directory_block'),
            'attributes' => array(
                'showCategories' => array(
                    'type' => 'boolean',
                    'default' => true,
                ),
                'postsPerPage' => array(
                    'type' => 'number',
                    'default' => 10,
                )
            )
        ));

        // User dashboard block
        register_block_type('wp-business-directory/user-dashboard-block', array(
            'editor_script' => 'wpbd-blocks-js',
            'editor_style' => 'wpbd-blocks-css',
            'render_callback' => array($this, 'render_user_dashboard_block'),
            'attributes' => array(
                'showLogin' => array(
                    'type' => 'boolean',
                    'default' => true,
                )
            )
        ));

        // Enqueue block editor assets
        wp_register_script(
            'wpbd-blocks-js',
            WPBD_PLUGIN_URL . 'assets/js/blocks.js',
            array('wp-blocks', 'wp-element', 'wp-editor', 'wp-components'),
            WPBD_VERSION
        );

        wp_register_style(
            'wpbd-blocks-css',
            WPBD_PLUGIN_URL . 'assets/css/blocks.css',
            array('wp-edit-blocks'),
            WPBD_VERSION
        );
    }

    /**
     * Render the directory block
     */
    public function render_directory_block($attributes)
    {
        ob_start();
        include WPBD_PLUGIN_PATH . 'templates/directory-block.php';
        return ob_get_clean();
    }

    /**
     * Render the user dashboard block
     */
    public function render_user_dashboard_block($attributes)
    {
        ob_start();
        include WPBD_PLUGIN_PATH . 'templates/user-dashboard-block.php';
        return ob_get_clean();
    }
}
