<?php
/**
 * Plugin installation and activation handler
 */

if (!defined('ABSPATH')) {
    exit;
}

class WPBD_Install {
    
    /**
     * Plugin activation
     */
    public static function activate() {
        // Create custom post types and flush rewrite rules
        $core = new WPBD_Core();
        $core->register_post_types();
        $core->register_taxonomies();
        
        flush_rewrite_rules();
        
        // Add default options
        add_option('wpbd_user_approval_required', 'yes');
        add_option('wpbd_default_listings_limit', 5);
        
        // Approve all existing administrators
        $admins = get_users(array('role' => 'administrator'));
        foreach ($admins as $admin) {
            update_user_meta($admin->ID, 'wpbd_approved', 1);
            update_user_meta($admin->ID, 'wpbd_listings_limit', 999); // Unlimited for admins
        }
    }
    
    /**
     * Plugin deactivation
     */
    public static function deactivate() {
        // Flush rewrite rules
        flush_rewrite_rules();
    }
    
    /**
     * Approve user (can be used when approving users)
     */
    public static function approve_user($user_id) {
        update_user_meta($user_id, 'wpbd_approved', 1);
        update_user_meta($user_id, 'wpbd_listings_limit', get_option('wpbd_default_listings_limit', 5));
    }
}
