<?php
/**
 * Directory block template
 */

// Get categories
$categories = get_terms(array(
    'taxonomy' => 'wpbd_category',
    'hide_empty' => false,
    'parent' => 0, // Get top-level categories
));

// Get initial listings (all if no category selected)
$category_id = isset($_GET['category']) ? intval($_GET['category']) : 0;

$query = null;
if ($category_id) {
    $args = array(
        'post_type' => 'wpbd_business',
        'post_status' => 'publish',
        'posts_per_page' => 10,
        'tax_query' => array(
            array(
                'taxonomy' => 'wpbd_category',
                'field' => 'term_id',
                'terms' => $category_id,
            ),
        ),
    );
    $query = new WP_Query($args);
}

// Get Featured Listings
$featured_args = array(
    'post_type' => 'wpbd_business',
    'post_status' => 'publish',
    'posts_per_page' => 5,
    'meta_key' => '_wpbd_featured',
    'meta_value' => '1',
);
$featured_query = new WP_Query($featured_args);
?>

<div id="wpbd-directory" class="wpbd-directory">

    <!-- Search Bar -->
    <div class="wpbd-search-container">
        <div class="wpbd-search-wrapper">
            <input type="text" id="wpbd-search-input"
                placeholder="<?php _e('Search by Business Name or NAICS Code...', 'wp-business-directory'); ?>" />
            <button id="wpbd-search-button" class="wpbd-search-button">
                <span class="dashicons dashicons-search"></span>
            </button>
        </div>
        <div id="wpbd-search-results" class="wpbd-search-results"></div>
    </div>

    <!-- Featured Listings -->
    <?php if ($featured_query->have_posts() && !$category_id): ?>
        <div class="wpbd-featured-listings">
            <h2><?php _e('Featured Businesses', 'wp-business-directory'); ?></h2>
            <div class="wpbd-listings-grid">
                <?php while ($featured_query->have_posts()):
                    $featured_query->the_post();
                    $description = get_post_meta(get_the_ID(), '_wpbd_description', true);
                    $phone = get_post_meta(get_the_ID(), '_wpbd_phone', true);
                    $address = get_post_meta(get_the_ID(), '_wpbd_address', true);
                    $website = get_post_meta(get_the_ID(), '_wpbd_website', true);
                    ?>
                    <div class="wpbd-business-listing wpbd-featured">
                        <?php if (has_post_thumbnail()): ?>
                            <div class="wpbd-business-logo">
                                <?php the_post_thumbnail('medium'); ?>
                            </div>
                        <?php endif; ?>
                        <h3 class="wpbd-business-title"><?php the_title(); ?>
                            <span class="wpbd-featured-badge"><?php _e('Featured', 'wp-business-directory'); ?></span>
                        </h3>
                        <div class="wpbd-business-content">
                            <?php if ($description): ?>
                                <p class="wpbd-description"><?php echo esc_html($description); ?></p>
                            <?php endif; ?>
                            <?php if ($phone): ?>
                                <p class="wpbd-phone"><span class="dashicons dashicons-phone"></span> <a
                                        href="tel:<?php echo esc_attr($phone); ?>"><?php echo esc_html($phone); ?></a></p>
                            <?php endif; ?>
                            <?php if ($address): ?>
                                <p class="wpbd-address"><span class="dashicons dashicons-location"></span>
                                    <?php echo esc_html($address); ?></p>
                            <?php endif; ?>
                            <?php if ($website): ?>
                                <p class="wpbd-website"><span class="dashicons dashicons-admin-site"></span> <a
                                        href="<?php echo esc_url($website); ?>" target="_blank"
                                        rel="noopener"><?php _e('Visit Website', 'wp-business-directory'); ?></a></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endwhile;
                wp_reset_postdata(); ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Breadcrumbs -->
    <nav class="wpbd-breadcrumbs">
        <a href="<?php echo get_permalink(); ?>"><?php _e('Home', 'wp-business-directory'); ?></a>
        <?php if ($category_id):
            $category = get_term($category_id, 'wpbd_category');
            ?>
            <span> &gt; <?php echo esc_html($category->name); ?></span>
        <?php endif; ?>
    </nav>

    <!-- Categories (Accordion) -->
    <?php if (!$category_id): ?>
        <div class="wpbd-categories">
            <h2><?php _e('Business Categories', 'wp-business-directory'); ?></h2>
            <ul class="wpbd-accordion">
                <?php foreach ($categories as $category):
                    $subcategories = get_terms(array(
                        'taxonomy' => 'wpbd_category',
                        'hide_empty' => false,
                        'parent' => $category->term_id,
                    ));
                    $has_children = !empty($subcategories);
                    ?>
                    <li class="<?php echo $has_children ? 'has-children' : ''; ?>">
                        <div class="wpbd-accordion-header">
                            <a href="#" class="wpbd-category-link" data-category="<?php echo $category->term_id; ?>">
                                <?php echo esc_html($category->name); ?>
                                <span class="wpbd-category-count">(<?php echo $category->count; ?>)</span>
                            </a>
                            <?php if ($has_children): ?>
                                <button class="wpbd-accordion-toggle" aria-expanded="true"><span
                                        class="dashicons dashicons-arrow-up-alt2"></span></button>
                            <?php endif; ?>
                        </div>
                        <?php if ($has_children): ?>
                            <ul class="wpbd-accordion-content">
                                <?php foreach ($subcategories as $subcategory): ?>
                                    <li>
                                        <a href="#" class="wpbd-category-link" data-category="<?php echo $subcategory->term_id; ?>">
                                            <?php echo esc_html($subcategory->name); ?>
                                            <span class="wpbd-category-count">(<?php echo $subcategory->count; ?>)</span>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <!-- Listings -->
    <div class="wpbd-listings">
        <?php if ($query && $query->have_posts()): ?>
            <?php while ($query->have_posts()):
                $query->the_post();
                $description = get_post_meta(get_the_ID(), '_wpbd_description', true);
                $phone = get_post_meta(get_the_ID(), '_wpbd_phone', true);
                $address = get_post_meta(get_the_ID(), '_wpbd_address', true);
                $website = get_post_meta(get_the_ID(), '_wpbd_website', true);
                $naics_code = get_post_meta(get_the_ID(), '_wpbd_naics_code', true);
                ?>
                <div class="wpbd-business-listing">
                    <div class="wpbd-business-header">
                        <?php if (has_post_thumbnail()): ?>
                            <div class="wpbd-business-logo">
                                <?php the_post_thumbnail('thumbnail'); ?>
                            </div>
                        <?php endif; ?>
                        <div class="wpbd-business-title">
                            <h3><?php the_title(); ?></h3>
                        </div>
                    </div>
                    <div class="wpbd-business-content">
                        <p class="wpbd-description"><?php echo esc_html($description); ?></p>
                        <?php if ($phone): ?>
                            <p class="wpbd-phone"><strong><?php _e('Phone:', 'wp-business-directory'); ?></strong>
                                <?php echo esc_html($phone); ?></p>
                        <?php endif; ?>
                        <?php if ($address): ?>
                            <p class="wpbd-address"><strong><?php _e('Address:', 'wp-business-directory'); ?></strong>
                                <?php echo esc_html($address); ?></p>
                        <?php endif; ?>
                        <?php if ($website): ?>
                            <p class="wpbd-website"><strong><?php _e('Website:', 'wp-business-directory'); ?></strong> <a
                                    href="<?php echo esc_url($website); ?>" target="_blank"><?php echo esc_html($website); ?></a>
                            </p>
                        <?php endif; ?>
                        <?php if ($naics_code): ?>
                            <p class="wpbd-naics"><strong><?php _e('NAICS Code:', 'wp-business-directory'); ?></strong>
                                <?php echo esc_html($naics_code); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php elseif ($category_id): ?>
            <p><?php _e('No business listings found in this category.', 'wp-business-directory'); ?></p>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if ($query && $query->max_num_pages > 1): ?>
        <nav class="wpbd-pagination">
            <?php
            echo paginate_links(array(
                'total' => $query->max_num_pages,
                'current' => max(1, get_query_var('paged')),
                'format' => '?paged=%#%',
                'show_all' => false,
                'type' => 'plain',
                'end_size' => 2,
                'mid_size' => 1,
                'prev_next' => true,
                'prev_text' => __('« Previous', 'wp-business-directory'),
                'next_text' => __('Next »', 'wp-business-directory'),
                'add_args' => false,
                'add_fragment' => '',
            ));
            ?>
        </nav>
    <?php endif; ?>
</div>