<?php
/**
 * User dashboard block template
 */

if (is_user_logged_in()) {
    $user_id = get_current_user_id();
    $approved = get_user_meta($user_id, 'wpbd_approved', true);
    $listings_limit = get_user_meta($user_id, 'wpbd_listings_limit', true);
    
    if (empty($listings_limit)) {
        $listings_limit = get_option('wpbd_default_listings_limit', 5);
    }
    
    $user_listings_count = count_user_posts($user_id, 'wpbd_business');
    ?>
    
    <div id="wpbd-user-dashboard" class="wpbd-user-dashboard">
        <h2><?php _e('My Business Dashboard', 'wp-business-directory'); ?></h2>
        
        <?php if ($approved) : ?>
            <div class="wpbd-dashboard-info">
                <p><?php _e('You are approved to submit business listings.', 'wp-business-directory'); ?></p>
                <p><?php printf(__('You have submitted %d of %d listings.', 'wp-business-directory'), $user_listings_count, $listings_limit); ?></p>
            </div>
            
            <div class="wpbd-dashboard-actions">
                <button id="wpbd-show-add-form" class="wpbd-button"><?php _e('Add New Business Listing', 'wp-business-directory'); ?></button>
            </div>
            
            <div id="wpbd-add-business-form" class="wpbd-add-business-form" style="display: none;">
                <h3><span id="form-title"><?php _e('Add New Business Listing', 'wp-business-directory'); ?></span></h3>
                <form id="wpbd-business-form">
                    <input type="hidden" id="wpbd-post-id" name="post_id" value="">
                    <div class="wpbd-form-row">
                        <label for="wpbd-business-name"><?php _e('Business Name *', 'wp-business-directory'); ?></label>
                        <input type="text" id="wpbd-business-name" name="business_name" required>
                    </div>
                    
                    <div class="wpbd-form-row">
                        <label for="wpbd-description"><?php _e('Description (max 150 characters) *', 'wp-business-directory'); ?></label>
                        <textarea id="wpbd-description" name="description" maxlength="150" required></textarea>
                    </div>
                    
                    <div class="wpbd-form-row">
                        <label for="wpbd-phone"><?php _e('Phone Number', 'wp-business-directory'); ?></label>
                        <input type="text" id="wpbd-phone" name="phone">
                    </div>
                    
                    <div class="wpbd-form-row">
                        <label for="wpbd-address"><?php _e('Address', 'wp-business-directory'); ?></label>
                        <input type="text" id="wpbd-address" name="address">
                    </div>
                    
                    <div class="wpbd-form-row">
                        <label for="wpbd-website"><?php _e('Website', 'wp-business-directory'); ?></label>
                        <input type="url" id="wpbd-website" name="website">
                    </div>
                    
                    <div class="wpbd-form-row">
                        <label for="wpbd-categories"><?php _e('Categories *', 'wp-business-directory'); ?></label>
                        <?php 
                        $categories = get_terms(array(
                            'taxonomy' => 'wpbd_category',
                            'hide_empty' => false,
                        ));
                        ?>
                        <select id="wpbd-categories" name="categories[]" multiple required>
                            <?php foreach ($categories as $category) : ?>
                                <option value="<?php echo $category->term_id; ?>"><?php echo esc_html($category->name); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="wpbd-form-row">
                        <label for="wpbd-logo"><?php _e('Logo', 'wp-business-directory'); ?></label>
                        <input type="file" id="wpbd-logo" name="logo" accept="image/*">
                        <p class="description"><?php _e('Leave blank to keep existing logo.', 'wp-business-directory'); ?></p>
                    </div>
                    
                    <div class="wpbd-form-row">
                        <button type="submit" class="wpbd-button"><span id="submit-button-text"><?php _e('Submit Listing', 'wp-business-directory'); ?></span></button>
                        <button type="button" id="wpbd-cancel-form" class="wpbd-button wpbd-button-secondary"><?php _e('Cancel', 'wp-business-directory'); ?></button>
                    </div>
                </form>
            </div>
            
            <div class="wpbd-user-businesses">
                <h3><?php _e('My Business Listings', 'wp-business-directory'); ?></h3>
                <div id="wpbd-business-list"></div>
            </div>
        <?php else : 
            // Check if user is admin
            if (current_user_can('manage_options')) : ?>
            <div class="wpbd-dashboard-info">
                <p><?php _e('You are an administrator and can manage all business listings.', 'wp-business-directory'); ?></p>
                <p><a href="<?php echo admin_url('edit.php?post_type=wpbd_business'); ?>" class="wpbd-button"><?php _e('Manage Business Listings in Admin', 'wp-business-directory'); ?></a></p>
            </div>
            
            <div class="wpbd-user-businesses">
                <h3><?php _e('My Business Listings', 'wp-business-directory'); ?></h3>
                <div id="wpbd-business-list"></div>
            </div>
        <?php else : ?>
            <div class="wpbd-dashboard-info">
                <p><?php _e('Your account is pending approval from an administrator.', 'wp-business-directory'); ?></p>
                <p><?php _e('You will be able to submit business listings once approved.', 'wp-business-directory'); ?></p>
            </div>
        <?php endif; endif; ?>
    </div>
    
    <?php
} else {
    // Show login/register form
    ?>
    <div id="wpbd-login-register" class="wpbd-login-register">
        <h2><?php _e('Business Directory Login', 'wp-business-directory'); ?></h2>
        
        <div class="wpbd-tabs">
            <button class="wpbd-tab-link active" data-tab="login"><?php _e('Login', 'wp-business-directory'); ?></button>
            <button class="wpbd-tab-link" data-tab="register"><?php _e('Register', 'wp-business-directory'); ?></button>
        </div>
        
        <div id="wpbd-login-tab" class="wpbd-tab-content active">
            <form id="wpbd-login-form">
                <div class="wpbd-form-row">
                    <label for="wpbd-login-username"><?php _e('Username or Email', 'wp-business-directory'); ?></label>
                    <input type="text" id="wpbd-login-username" name="username" required>
                </div>
                
                <div class="wpbd-form-row">
                    <label for="wpbd-login-password"><?php _e('Password', 'wp-business-directory'); ?></label>
                    <input type="password" id="wpbd-login-password" name="password" required>
                </div>
                
                <div class="wpbd-form-row">
                    <button type="submit" class="wpbd-button"><?php _e('Login', 'wp-business-directory'); ?></button>
                </div>
            </form>
        </div>
        
        <div id="wpbd-register-tab" class="wpbd-tab-content">
            <form id="wpbd-register-form">
                <div class="wpbd-form-row">
                    <label for="wpbd-register-username"><?php _e('Username *', 'wp-business-directory'); ?></label>
                    <input type="text" id="wpbd-register-username" name="username" required>
                </div>
                
                <div class="wpbd-form-row">
                    <label for="wpbd-register-email"><?php _e('Email *', 'wp-business-directory'); ?></label>
                    <input type="email" id="wpbd-register-email" name="email" required>
                </div>
                
                <div class="wpbd-form-row">
                    <label for="wpbd-register-password"><?php _e('Password *', 'wp-business-directory'); ?></label>
                    <input type="password" id="wpbd-register-password" name="password" required>
                </div>
                
                <div class="wpbd-form-row">
                    <label for="wpbd-register-confirm-password"><?php _e('Confirm Password *', 'wp-business-directory'); ?></label>
                    <input type="password" id="wpbd-register-confirm-password" name="confirm_password" required>
                </div>
                
                <div class="wpbd-form-row">
                    <button type="submit" class="wpbd-button"><?php _e('Register', 'wp-business-directory'); ?></button>
                </div>
            </form>
        </div>
    </div>
    <?php
}
