<?php
/**
 * Plugin Name: WP Business Directory
 * Plugin URI: https://example.com/wp-business-directory
 * Description: A comprehensive business directory plugin for WordPress with category filtering, user management, and frontend dashboard.
 * Version: 1.0.0
 * Author: Your Name
 * Author URI: https://example.com
 * Text Domain: wp-business-directory
 * Domain Path: /languages
 * License: GPL v2 or later
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('WPBD_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('WPBD_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WPBD_VERSION', '1.0.0');

// Autoload classes
spl_autoload_register(function ($class) {
    $prefix = 'WPBD_';
    $base_dir = WPBD_PLUGIN_PATH . 'includes/';
    
    if (strncmp($prefix, $class, strlen($prefix)) !== 0) {
        return;
    }
    
    $relative_class = substr($class, strlen($prefix));
    $file = $base_dir . str_replace('_', '/', $relative_class) . '.php';
    
    if (file_exists($file)) {
        require $file;
    }
});

// Initialize the plugin
function wpbd_init() {
    // Initialize core functionality
    new WPBD_Core();
    
    // Initialize admin functionality
    if (is_admin()) {
        new WPBD_Admin();
    }
    
    // Initialize public functionality
    if (!is_admin() || defined('DOING_AJAX') && DOING_AJAX) {
        new WPBD_Public();
    }
}
add_action('plugins_loaded', 'wpbd_init');

// Activation hook
register_activation_hook(__FILE__, array('WPBD_Install', 'activate'));

// Deactivation hook
register_deactivation_hook(__FILE__, array('WPBD_Install', 'deactivate'));

// Add login/logout redirects
add_action('wp_logout', 'wpbd_redirect_after_logout');
add_filter('authenticate', 'wpbd_redirect_after_login', 30, 3);

/**
 * Redirect after logout
 */
function wpbd_redirect_after_logout() {
    wp_redirect(home_url());
    exit();
}

/**
 * Handle redirect after login
 */
function wpbd_redirect_after_login($user, $username, $password) {
    if (is_wp_error($user)) {
        return $user;
    }
    
    // Redirect to the same page after login
    if (isset($_POST['redirect_to']) && !empty($_POST['redirect_to'])) {
        return $user;
    }
    
    return $user;
}
