<?php
/**
 * Template: Logo Form Field
 * 
 * This template renders the logo upload field in the add/edit listing form.
 *
 * @var array $data Field data from the form builder
 * @var int   $listing_id Current listing ID (0 for new listings)
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Extract field data
$field_key   = isset( $data['field_key'] ) ? $data['field_key'] : 'directorist_logo';
$label       = isset( $data['label'] ) ? $data['label'] : __( 'Logo', 'directorist-logo-field' );
$placeholder = isset( $data['placeholder'] ) ? $data['placeholder'] : __( 'Click to upload logo', 'directorist-logo-field' );
$required    = ! empty( $data['required'] );
$max_size    = isset( $data['max_file_size'] ) ? intval( $data['max_file_size'] ) : 2048;
$select_label = __( 'Select Logo', 'directorist-logo-field' );

// Get listing ID from various sources
$listing_id = 0;
if ( isset( $data['listing_id'] ) ) {
    $listing_id = absint( $data['listing_id'] );
} elseif ( isset( $_GET['edit'] ) ) {
    $listing_id = absint( $_GET['edit'] );
} elseif ( isset( $GLOBALS['listing_id'] ) ) {
    $listing_id = absint( $GLOBALS['listing_id'] );
}

// Get existing value
$logo_id  = 0;
$logo_url = '';

if ( $listing_id ) {
    $logo_id = get_post_meta( $listing_id, '_directorist_logo', true );
    if ( $logo_id ) {
        $logo_url = wp_get_attachment_image_url( $logo_id, 'medium' );
    }
}

$has_logo = ! empty( $logo_url );
$required_class = $required ? 'directorist-form-required' : '';

$accepted_mime_types = function_exists( 'directorist_get_mime_types' )
    ? directorist_get_mime_types( 'image', 'extension' )
    : array( 'jpg', 'jpeg', 'png', 'gif', 'webp' );
$accepted_mime_types_upper = array_map( 'strtoupper', $accepted_mime_types );
$accepted_mime_types       = array_merge( $accepted_mime_types, $accepted_mime_types_upper );

$upload_data = array(
    'type'               => join( ', ', $accepted_mime_types ),
    'max_num_of_img'     => 1,
    'max_total_img_size' => $max_size,
    'is_required'        => $required ? 1 : 0,
    'max_size_per_img'   => $max_size,
    'allow_multiple'     => 0,
    'show_alerts'        => 0,
    'show_file_size'     => 0,
    'featured'           => 0,
    'allow_sorting'      => 0,
    'show_info'          => 0,
    'uploader_type'      => 'avater',
);
$upload_data = wp_json_encode( $upload_data );

$use_simple_uploader = is_user_logged_in() && ! current_user_can( 'upload_files' );
$use_simple_uploader = apply_filters( 'directorist_logo_field_use_simple_uploader', $use_simple_uploader, $data, $listing_id );
?>
<div class="directorist-form-group directorist-form-image-upload-field directorist-logo-field-wrap <?php echo esc_attr( $required_class ); ?>">
    <label class="directorist-form-label">
        <?php echo esc_html( $label ); ?>
        <?php if ( $required ) : ?>
            <span class="directorist-form-required-mark">*</span>
        <?php endif; ?>
    </label>

    <?php if ( $use_simple_uploader ) : ?>
        <div class="directorist-logo-upload-area <?php echo $has_logo ? 'has-logo' : ''; ?>"
             data-max-size="<?php echo esc_attr( $max_size ); ?>">

            <input type="hidden"
                   name="directorist_logo"
                   id="directorist_logo_id"
                   value="<?php echo esc_attr( $logo_id ); ?>"
                   class="directorist-logo-input" />
            <?php if ( ! empty( $field_key ) && 'directorist_logo' !== $field_key ) : ?>
                <input type="hidden"
                       name="<?php echo esc_attr( $field_key ); ?>"
                       id="<?php echo esc_attr( $field_key ); ?>_logo_id"
                       value="<?php echo esc_attr( $logo_id ); ?>"
                       class="directorist-logo-input directorist-logo-input--alias" />
            <?php endif; ?>

            <div class="directorist-logo-preview" <?php echo ! $has_logo ? 'style="display:none;"' : ''; ?>>
                <img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php echo esc_attr( $label ); ?>" />
                <button type="button" class="directorist-logo-remove" title="<?php esc_attr_e( 'Remove logo', 'directorist-logo-field' ); ?>">
                    <span class="la la-times"></span>
                </button>
            </div>

            <div class="directorist-logo-upload-btn" <?php echo $has_logo ? 'style="display:none;"' : ''; ?>>
                <span class="la la-cloud-upload"></span>
                <span class="directorist-logo-placeholder"><?php echo esc_html( $placeholder ); ?></span>
                <span class="directorist-logo-hint">
                    <?php
                    printf(
                        esc_html__( 'JPG, PNG, GIF or WebP. Max %s KB', 'directorist-logo-field' ),
                        number_format( $max_size )
                    );
                    ?>
                </span>
            </div>
        </div>
    <?php else : ?>
        <div class="ez-media-uploader directorist-logo-uploader" data-uploader="<?php echo esc_attr( $upload_data ); ?>" data-field-key="<?php echo esc_attr( $field_key ); ?>">
            <div class="ezmu__loading-section ezmu--show">
                <span class="ezmu__loading-icon"><span class="ezmu__loading-icon-img-bg"></span></span>
            </div>
            <div class="ezmu__old-files">
                <?php if ( $logo_id ) : ?>
                    <?php
                    $logo_path = get_attached_file( $logo_id );
                    $logo_size = $logo_path && file_exists( $logo_path ) ? filesize( $logo_path ) / 1024 : 0;
                    ?>
                    <span class="ezmu__old-files-meta"
                        data-attachment-id="<?php echo esc_attr( $logo_id ); ?>"
                        data-url="<?php echo esc_url( $logo_url ); ?>"
                        data-size="<?php echo esc_attr( $logo_size ); ?>"
                        data-type="image"></span>
                <?php endif; ?>
            </div>
            <div class="ezmu-dictionary">
                <span class="ezmu-dictionary-label-drop-here"><?php esc_html_e( 'Drop Here', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-label-featured"><?php esc_html_e( 'Preview', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-label-drag-n-drop"><?php esc_html_e( 'Drag and drop an image', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-label-or"><?php esc_html_e( 'or', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-label-select-files"><?php echo esc_html( $select_label ); ?></span>
                <span class="ezmu-dictionary-label-to"><?php esc_html_e( 'or drag and drop image here', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-label-add-more"><?php esc_html_e( 'Add More', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-alert-max-file-size"><?php esc_html_e( 'Maximum limit for a file is  __DT__', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-alert-max-total-file-size"><?php esc_html_e( 'Maximum limit for total file size is __DT__', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-alert-min-file-items"><?php esc_html_e( 'Minimum __DT__ file is required', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-alert-max-file-items"><?php esc_html_e( 'Maximum limit for total file is __DT__', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-info-max-file-size"><?php esc_html_e( 'Maximum allowed size per file is __DT__', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-info-max-total-file-size"><?php esc_html_e( 'Maximum total allowed file size is __DT__', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-info-type"></span>
                <span class="ezmu-dictionary-info-min-file-items"><?php esc_html_e( 'Minimum __DT__ file is required', 'directorist' ); ?></span>
                <span class="ezmu-dictionary-info-max-file-items"><?php esc_html_e( 'Maximum __DT__ file is allowed', 'directorist' ); ?></span>
            </div>
        </div>
    <?php endif; ?>
</div>
