<?php
/**
 * Template: Logo Display
 * 
 * This template can be overridden by copying it to:
 * yourtheme/directorist/logo-display.php
 *
 * @var int    $listing_id   The listing ID
 * @var string $logo_url     The logo image URL
 * @var string $alt_text     Alt text for the image
 * @var int    $width        Display width
 * @var int    $height       Display height
 * @var string $label        Field label
 * @var bool   $show_label   Whether to show label
 * @var string $context      Display context (single|card)
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( empty( $logo_url ) ) {
    return;
}

$show_on_listings = true;
if ( class_exists( 'Directorist_Logo_Field_Settings' ) ) {
    $show_on_listings = Directorist_Logo_Field_Settings::get_option( 'show_on_listings', 1 );
}

if ( 'card' === $context && ! $show_on_listings ) {
    return;
}

$class = 'single' === $context ? 'directorist-single-logo' : 'directorist-card-logo';

$style = '';
if ( $width ) {
    $style .= 'max-width: ' . intval( $width ) . 'px; ';
}
if ( $height ) {
    $style .= 'max-height: ' . intval( $height ) . 'px; ';
}
?>
<div class="directorist-logo-display <?php echo esc_attr( $class ); ?>">
    <?php if ( $show_label && $label ) : ?>
        <span class="directorist-logo-label"><?php echo esc_html( $label ); ?>:</span>
    <?php endif; ?>
    <?php if ( 'card' === $context ) : ?>
        <a class="directorist-logo-link" href="<?php echo esc_url( get_permalink( $listing_id ) ); ?>">
            <img src="<?php echo esc_url( $logo_url ); ?>" 
                 alt="<?php echo esc_attr( $alt_text ); ?>" 
                 class="directorist-logo-image"
                 style="<?php echo esc_attr( trim( $style ) ); ?>"
                 loading="lazy" />
        </a>
    <?php else : ?>
        <img src="<?php echo esc_url( $logo_url ); ?>" 
             alt="<?php echo esc_attr( $alt_text ); ?>" 
             class="directorist-logo-image"
             style="<?php echo esc_attr( trim( $style ) ); ?>"
             loading="lazy" />
    <?php endif; ?>
</div>
