# Ravenpine Restaurant One Pager Theme

This is a native block WordPress theme for restaurant one-page sites.

## Included Features

- Hero slider section (dynamic block) with 2-column overlay:
  - Left column: logo from Site Identity.
  - Right column: write-up from Customizer settings.
  - 50/50 column layout.
  - Optional colored cards behind logo/content (toggle in Customizer).
  - Hero image overlay color/opacity control in Customizer.
- Slider management in admin via **Hero Slides** post type.
- Menu management in admin via **Restaurant Menus** post type:
  - Upload/select PDF or image from media library.
  - Front-end renders as styled menu buttons.
- Gallery management in admin via **Appearance > Gallery Manager**:
  - Add multiple images at once from Media Library.
  - Drag-and-drop reorder, remove, and save from one screen.
  - Section auto-hides if no gallery images exist.
- Location & Hours management via **Appearance > Restaurant Info**.
- About Us management via **Appearance > Restaurant Info** with optional side image.
- Google Maps embed support.
- Customizer controls for:
  - Hero overlay content.
  - Menu section heading text and section alignment.
  - Menu section eyebrow text and menu section colors.
  - Gallery section heading text.
- Extensive per-element colors (header, hero cards, hero button, menu buttons, footer/tagline, etc.).
  - Color controls now use a visual picker with opacity slider and a one-click transparent option.
  - Includes menu section colors, location/hours card background color, and hero image overlay color.
- Heading/body font families.
  - Upload font files (WOFF2/WOFF/TTF/OTF) and select them from the same Heading/Body dropdowns as built-in fonts.
- Fixed full-page background image.
  - Section padding.
  - Section border controls (top/bottom toggle, border width, border color with opacity).
  - Social media links.
- Header anchor links block for one-page section navigation.
- Footer tagline that only renders when a site tagline exists.
- Smooth scroll-reveal animation for one-page section content.
- Social links block for bottom-of-page display.
- One-page front-page template using native blocks.
- Appearance editor is disabled to prevent style/template overrides outside this theme system.
- Masonry gallery with rounded images, hover scale effect, and lightbox view.
- No default gap between one-page sections.

## Blocks Added

- `ravenpine/hero-slider`
- `ravenpine/menu-buttons`
- `ravenpine/location-hours`
- `ravenpine/about-us`
- `ravenpine/social-links`
- `ravenpine/masonry-gallery`
- `ravenpine/anchor-nav`
- `ravenpine/optional-tagline`

## Admin Areas

- **Hero Slides**: manage slider images and order.
- **Restaurant Menus**: manage downloadable/viewable menu links.
- **Appearance > Gallery Manager**: bulk-manage masonry gallery photos in one place.
- **Appearance > Restaurant Info**: About Us, address, phone, email, hours, map URL.
- **Appearance > Customize** (`/wp-admin/customize.php`): logo/favicon/site style + social links.
- **Appearance > Editor** is intentionally disabled.

## Rearranging Homepage Sections

Edit `templates/front-page.html` directly in the theme to change section order.

## Notes

- If map embed URL is blank, map iframe uses the address as a Google Maps query embed.
- Hero slide order uses the page `Order` field in each Hero Slide.
