jQuery(function ($) {
  var $list = $('#ravenpine-gallery-sortable');
  var $input = $('#ravenpine_gallery_image_ids');
  var frame;

  if (!$list.length || !$input.length) {
    return;
  }

  function currentIds() {
    var ids = [];
    $list.find('.rpx-gallery-item').each(function () {
      var id = parseInt($(this).attr('data-id'), 10);
      if (!isNaN(id) && ids.indexOf(id) === -1) {
        ids.push(id);
      }
    });
    return ids;
  }

  function syncInput() {
    $input.val(currentIds().join(','));
  }

  function itemHtml(item) {
    var thumb = item.sizes && item.sizes.thumbnail ? item.sizes.thumbnail.url : item.url;
    var title = item.title || ('Image #' + item.id);

    return (
      '<li class="rpx-gallery-item" data-id="' + item.id + '">' +
      '<div class="rpx-gallery-item-handle" aria-hidden="true">&#9776;</div>' +
      '<img src="' + thumb + '" alt="" />' +
      '<div class="rpx-gallery-item-meta">' +
      '<strong>' + $('<div/>').text(title).html() + '</strong>' +
      '<a href="' + item.url + '" target="_blank" rel="noopener noreferrer">Preview</a>' +
      '</div>' +
      '<button type="button" class="button-link-delete rpx-gallery-remove">Remove</button>' +
      '</li>'
    );
  }

  function appendItem(item) {
    if ($list.find('.rpx-gallery-item[data-id="' + item.id + '"]').length) {
      return;
    }
    $list.append(itemHtml(item));
    syncInput();
  }

  $list.sortable({
    handle: '.rpx-gallery-item-handle',
    update: syncInput
  });

  $list.on('click', '.rpx-gallery-remove', function () {
    $(this).closest('.rpx-gallery-item').remove();
    syncInput();
  });

  $('#ravenpine-gallery-clear-images').on('click', function () {
    $list.empty();
    syncInput();
  });

  $('#ravenpine-gallery-add-images').on('click', function (event) {
    event.preventDefault();

    if (!frame) {
      frame = wp.media({
        title: 'Select Gallery Images',
        button: { text: 'Add to Gallery' },
        multiple: true,
        library: { type: 'image' }
      });

      frame.on('select', function () {
        var selection = frame.state().get('selection');
        selection.each(function (attachment) {
          appendItem(attachment.toJSON());
        });
      });
    }

    frame.open();
  });

  syncInput();
});
