jQuery(function ($) {
  var frame;

  $('#ravenpine-upload-menu-file').on('click', function (event) {
    event.preventDefault();

    if (frame) {
      frame.open();
      return;
    }

    frame = wp.media({
      title: 'Select Menu File',
      button: {
        text: 'Use this file'
      },
      multiple: false,
      library: {
        type: ['application/pdf', 'image']
      }
    });

    frame.on('select', function () {
      var attachment = frame.state().get('selection').first().toJSON();
      $('#ravenpine_menu_url').val(attachment.url).trigger('change');
    });

    frame.open();
  });
});
