jQuery(function ($) {
  $('.rpx-admin-image-picker').each(function () {
    var $picker = $(this);
    var $input = $picker.find('.rpx-media-url');
    var $upload = $picker.find('.rpx-media-upload');
    var $remove = $picker.find('.rpx-media-remove');
    var $preview = $picker.find('.rpx-media-preview');
    var $previewImage = $preview.find('img');
    var frame;

    if (!$input.length || !$upload.length) {
      return;
    }

    $upload.on('click', function (event) {
      event.preventDefault();

      if (frame) {
        frame.open();
        return;
      }

      frame = wp.media({
        title: 'Select About Us Image',
        button: {
          text: 'Use this image'
        },
        multiple: false,
        library: {
          type: 'image'
        }
      });

      frame.on('select', function () {
        var attachment = frame.state().get('selection').first().toJSON();
        if (!attachment || !attachment.url) {
          return;
        }

        $input.val(attachment.url).trigger('change');
        $previewImage.attr('src', attachment.url);
        $preview.removeClass('is-hidden');
        $remove.removeClass('is-hidden');
      });

      frame.open();
    });

    $remove.on('click', function (event) {
      event.preventDefault();
      $input.val('').trigger('change');
      $previewImage.attr('src', '');
      $preview.addClass('is-hidden');
      $remove.addClass('is-hidden');
    });
  });

  var editorId = 'ravenpine_additional_info';
  var storageKey = 'rpx_editor_dark_mode_' + editorId;
  var $toggle = $('[data-rpx-editor-dark-toggle="' + editorId + '"]');
  var $editorWrap = $('#wp-' + editorId + '-wrap');
  var darkEnabled = false;

  function setToggleLabel(enabled) {
    if (!$toggle.length) {
      return;
    }
    $toggle.text(enabled ? 'Disable Editor Dark Mode' : 'Enable Editor Dark Mode');
    $toggle.attr('aria-pressed', enabled ? 'true' : 'false');
    $toggle.toggleClass('button-primary', enabled);
  }

  function getEditorBody() {
    if (window.tinymce && typeof window.tinymce.get === 'function') {
      var editor = window.tinymce.get(editorId);
      if (editor && editor.initialized && typeof editor.getBody === 'function') {
        return editor.getBody();
      }
    }

    var iframe = document.getElementById(editorId + '_ifr');
    if (!iframe || !iframe.contentDocument || !iframe.contentDocument.body) {
      return null;
    }
    return iframe.contentDocument.body;
  }

  function applyEditorDarkMode(enabled) {
    if ($editorWrap.length) {
      $editorWrap.toggleClass('rpx-editor-dark-mode', enabled);
    }

    var body = getEditorBody();
    if (body) {
      body.style.backgroundColor = enabled ? '#111827' : '';
      body.style.color = enabled ? '#f8fafc' : '';
      body.style.caretColor = enabled ? '#f8fafc' : '';
    }

    setToggleLabel(enabled);
  }

  if ($toggle.length) {
    try {
      darkEnabled = window.localStorage.getItem(storageKey) === '1';
    } catch (error) {
      darkEnabled = false;
    }

    applyEditorDarkMode(darkEnabled);

    $toggle.on('click', function (event) {
      event.preventDefault();
      darkEnabled = !darkEnabled;

      try {
        window.localStorage.setItem(storageKey, darkEnabled ? '1' : '0');
      } catch (error) {
        // Ignore storage errors.
      }

      applyEditorDarkMode(darkEnabled);
    });

    if (window.tinymce && typeof window.tinymce.on === 'function') {
      window.tinymce.on('AddEditor', function (event) {
        if (!event || !event.editor || event.editor.id !== editorId) {
          return;
        }

        event.editor.on('init', function () {
          applyEditorDarkMode(darkEnabled);
        });
      });
    }

    var existingEditor = window.tinymce && typeof window.tinymce.get === 'function' ? window.tinymce.get(editorId) : null;
    if (existingEditor) {
      existingEditor.on('init', function () {
        applyEditorDarkMode(darkEnabled);
      });

      if (existingEditor.initialized) {
        applyEditorDarkMode(darkEnabled);
      }
    }

    $(document).on('click', '#wp-' + editorId + '-wrap .switch-tmce, #wp-' + editorId + '-wrap .switch-html', function () {
      window.setTimeout(function () {
        applyEditorDarkMode(darkEnabled);
      }, 40);
    });
  }
});
