(function () {
  var INIT_FLAG = '__rpxGalleryLightboxInit';
  var handlersBound = false;
  var lightbox = null;
  var image = null;
  var index = 0;

  if (window[INIT_FLAG]) {
    return;
  }
  window[INIT_FLAG] = true;

  function getItems() {
    return Array.prototype.slice.call(document.querySelectorAll('[data-rpx-lightbox-item]'));
  }

  function getFullUrl(item) {
    return item ? item.getAttribute('data-rpx-full') || item.getAttribute('href') || '' : '';
  }

  function show(i) {
    var items = getItems();
    if (!items.length || !image) {
      return;
    }

    if (i >= items.length) {
      i = 0;
    } else if (i < 0) {
      i = items.length - 1;
    }

    index = i;
    var item = items[index];
    var itemImage = item.querySelector('img');

    image.setAttribute('src', getFullUrl(item));
    image.setAttribute('alt', itemImage ? itemImage.getAttribute('alt') || '' : '');
  }

  function close() {
    if (!lightbox) {
      return;
    }

    lightbox.classList.remove('is-open');
    lightbox.setAttribute('aria-hidden', 'true');
    document.body.classList.remove('rpx-lightbox-no-scroll');
    if (image) {
      image.setAttribute('src', '');
    }
  }

  function next() {
    show(index + 1);
  }

  function prev() {
    show(index - 1);
  }

  function ensureLightbox() {
    if (lightbox) {
      return true;
    }

    if (!getItems().length) {
      return false;
    }

    lightbox = document.createElement('div');
    lightbox.className = 'rpx-lightbox';
    lightbox.setAttribute('aria-hidden', 'true');
    lightbox.innerHTML =
      '<div class="rpx-lightbox-inner" role="dialog" aria-modal="true">' +
      '<button type="button" class="rpx-lightbox-close" aria-label="Close">\u2715</button>' +
      '<button type="button" class="rpx-lightbox-prev" aria-label="Previous">\u2039</button>' +
      '<img class="rpx-lightbox-image" alt="" />' +
      '<button type="button" class="rpx-lightbox-next" aria-label="Next">\u203a</button>' +
      '</div>';

    document.body.appendChild(lightbox);

    image = lightbox.querySelector('.rpx-lightbox-image');

    lightbox.querySelector('.rpx-lightbox-close').addEventListener('click', close);
    lightbox.querySelector('.rpx-lightbox-next').addEventListener('click', next);
    lightbox.querySelector('.rpx-lightbox-prev').addEventListener('click', prev);

    lightbox.addEventListener('click', function (event) {
      if (event.target === lightbox) {
        close();
      }
    });

    document.addEventListener('keydown', function (event) {
      if (!lightbox || !lightbox.classList.contains('is-open')) {
        return;
      }

      if (event.key === 'Escape') {
        close();
      } else if (event.key === 'ArrowRight') {
        next();
      } else if (event.key === 'ArrowLeft') {
        prev();
      }
    });

    return true;
  }

  function open(i) {
    if (!ensureLightbox()) {
      return;
    }

    show(i);
    lightbox.classList.add('is-open');
    lightbox.setAttribute('aria-hidden', 'false');
    document.body.classList.add('rpx-lightbox-no-scroll');
  }

  function handleItemClick(event) {
    var target = event.target;
    if (!target || typeof target.closest !== 'function') {
      return;
    }

    var trigger = target.closest('[data-rpx-lightbox-item]');
    if (!trigger) {
      return;
    }

    event.preventDefault();
    var items = getItems();
    var triggerIndex = items.indexOf(trigger);
    open(triggerIndex > -1 ? triggerIndex : 0);
  }

  function initGalleryLightbox() {
    if (handlersBound) {
      return;
    }

    document.addEventListener('click', handleItemClick);
    handlersBound = true;
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initGalleryLightbox);
  } else {
    initGalleryLightbox();
  }

  window.addEventListener('pageshow', initGalleryLightbox);
})();
