(function () {
  var INIT_FLAG = '__rpxRevealInit';

  if (window[INIT_FLAG]) {
    return;
  }
  window[INIT_FLAG] = true;

  function collectRevealTargets() {
    var targets = [];
    var selectors = [
      '.rpx-site-header .wp-block-site-logo',
      '.rpx-site-header .rpx-anchor-nav-wrap',
      '.rpx-hero-overlay > *',
      '.rpx-section .rpx-section-inner > *',
      '.rpx-site-footer .wp-block-group > *',
      '.rpx-anchor-nav li',
      '.rpx-masonry-item'
    ];

    selectors.forEach(function (selector) {
      document.querySelectorAll(selector).forEach(function (el) {
        targets.push(el);
      });
    });

    return Array.from(new Set(targets));
  }

  function isTopViewportTarget(el) {
    var rect = el.getBoundingClientRect();
    var viewHeight = Math.max(window.innerHeight || 0, 1);
    return rect.bottom > 0 && rect.top < viewHeight * 0.9;
  }

  function applyRevealClass(targets) {
    targets.forEach(function (el, index) {
      if (!el.classList.contains('rpx-reveal')) {
        el.classList.add('rpx-reveal');
      }

      if (el.classList.contains('rpx-hero-overlay__logo')) {
        el.setAttribute('data-rpx-reveal-direction', 'left');
      } else if (el.classList.contains('rpx-hero-overlay__content')) {
        el.setAttribute('data-rpx-reveal-direction', 'right');
      } else {
        el.setAttribute('data-rpx-reveal-direction', 'up');
      }

      el.style.setProperty('--rpx-reveal-delay', ((index % 6) * 70) + 'ms');
    });
  }

  function revealInitialViewportTargets(targets) {
    var initialTargets = targets.filter(isTopViewportTarget).sort(function (a, b) {
      return a.getBoundingClientRect().top - b.getBoundingClientRect().top;
    });

    initialTargets.forEach(function (el, index) {
      el.style.setProperty('--rpx-reveal-delay', (index * 80) + 'ms');
      el.classList.add('is-visible');
    });
  }

  function initScrollReveal() {
    if (window.matchMedia('(prefers-reduced-motion: reduce)').matches) {
      return;
    }

    var targets = collectRevealTargets();
    if (!targets.length) {
      return;
    }

    applyRevealClass(targets);
    revealInitialViewportTargets(targets);

    if (!('IntersectionObserver' in window)) {
      targets.forEach(function (el) {
        el.classList.add('is-visible');
      });
      return;
    }

    var observer = new IntersectionObserver(
      function (entries) {
        entries.forEach(function (entry) {
          if (entry.isIntersecting && entry.intersectionRatio >= 0.16) {
            entry.target.classList.add('is-visible');
            return;
          }

          if (!entry.isIntersecting || entry.intersectionRatio <= 0.04) {
            entry.target.classList.remove('is-visible');
          }
        });
      },
      {
        threshold: [0, 0.04, 0.16, 0.3, 0.5],
        rootMargin: '0px 0px -6% 0px'
      }
    );

    targets.forEach(function (el) {
      observer.observe(el);
    });
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initScrollReveal);
  } else {
    initScrollReveal();
  }

  window.addEventListener('pageshow', initScrollReveal);
})();
