<?php
/**
 * Render callback for About Us block.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-scroll-reveal' );
}

$settings      = function_exists( 'ravenpine_get_restaurant_settings' ) ? ravenpine_get_restaurant_settings() : array();
$about_heading = isset( $settings['about_us_heading'] ) ? $settings['about_us_heading'] : '';
$about_body    = isset( $settings['about_us_body'] ) ? $settings['about_us_body'] : '';
$about_image   = isset( $settings['about_us_image_url'] ) ? $settings['about_us_image_url'] : '';

$about_heading = '' !== trim( (string) $about_heading ) ? $about_heading : __( 'About Us', 'ravenpine' );
$about_body    = '' !== trim( (string) $about_body ) ? $about_body : __( 'Add your restaurant story in Appearance > Restaurant Info to customize this section.', 'ravenpine' );

$has_image = ! empty( $about_image );
$section_id = ( isset( $attributes['anchor'] ) && ! empty( $attributes['anchor'] ) ) ? sanitize_title( $attributes['anchor'] ) : 'about-us';

$wrapper_attributes = get_block_wrapper_attributes(
	array(
		'class' => 'rpx-section rpx-about-us' . ( $has_image ? ' has-image' : ' no-image' ),
		'id'    => $section_id,
	)
);
?>
<section <?php echo wp_kses_data( $wrapper_attributes ); ?>>
	<div class="rpx-section-inner">
		<div class="rpx-about-us-grid<?php echo $has_image ? ' has-image' : ' no-image'; ?>">
			<div class="rpx-about-us-copy">
				<p class="rpx-eyebrow"><?php esc_html_e( 'Our Story', 'ravenpine' ); ?></p>
				<h2><?php echo esc_html( $about_heading ); ?></h2>
				<?php foreach ( preg_split( '/\r\n|\r|\n/', (string) $about_body ) as $paragraph ) : ?>
					<?php if ( '' === trim( $paragraph ) ) : ?>
						<?php continue; ?>
					<?php endif; ?>
					<p><?php echo esc_html( $paragraph ); ?></p>
				<?php endforeach; ?>
			</div>
			<?php if ( $has_image ) : ?>
				<div class="rpx-about-us-media">
					<img src="<?php echo esc_url( $about_image ); ?>" alt="<?php echo esc_attr( $about_heading ); ?>" loading="lazy" decoding="async" />
				</div>
			<?php endif; ?>
		</div>
	</div>
</section>
