<?php
/**
 * Render callback for Anchor Navigation block.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-scroll-reveal' );
}

$links = array(
	__( 'Home', 'ravenpine' )             => '#home',
	__( 'Menus', 'ravenpine' )            => '#menus',
	__( 'About Us', 'ravenpine' )         => '#about-us',
	__( 'Location & Hours', 'ravenpine' ) => '#location-hours',
);

$gallery_visible = false;

if ( function_exists( 'ravenpine_get_gallery_image_ids' ) ) {
	$gallery_visible = ! empty( ravenpine_get_gallery_image_ids() );
}

if ( ! $gallery_visible ) {
	$gallery_count = wp_count_posts( 'rpx_gallery' );
	$gallery_visible = isset( $gallery_count->publish ) && (int) $gallery_count->publish > 0;
}

if ( $gallery_visible ) {
	$links[ __( 'Gallery', 'ravenpine' ) ] = '#gallery';
}

if ( function_exists( 'ravenpine_get_social_links' ) && ! empty( ravenpine_get_social_links() ) ) {
	$links[ __( 'Social', 'ravenpine' ) ] = '#social-links';
}

$wrapper_attributes = get_block_wrapper_attributes(
	array(
		'class' => 'rpx-anchor-nav-wrap',
	)
);
?>
<nav <?php echo wp_kses_data( $wrapper_attributes ); ?> aria-label="<?php esc_attr_e( 'Section navigation', 'ravenpine' ); ?>">
	<ul class="rpx-anchor-nav">
		<?php foreach ( $links as $label => $url ) : ?>
			<li><a href="<?php echo esc_url( $url ); ?>"><?php echo esc_html( $label ); ?></a></li>
		<?php endforeach; ?>
	</ul>
</nav>
