<?php
/**
 * Render callback for Footer Brand block.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-scroll-reveal' );
}

$site_name      = get_bloginfo( 'name' );
$footer_logo    = esc_url_raw( get_theme_mod( 'ravenpine_footer_logo', '' ) );
$custom_logo_id = absint( get_theme_mod( 'custom_logo' ) );
$logo_html      = '';

if ( ! empty( $footer_logo ) ) {
	$logo_html = sprintf(
		'<img class="rpx-footer-logo-custom" src="%1$s" alt="%2$s" loading="lazy" decoding="async" />',
		esc_url( $footer_logo ),
		esc_attr( $site_name )
	);
} elseif ( $custom_logo_id ) {
	$logo_html = wp_get_attachment_image(
		$custom_logo_id,
		'full',
		false,
		array(
			'class'   => 'rpx-footer-logo-custom',
			'loading' => 'lazy',
		)
	);
}

if ( '' === $logo_html ) {
	$logo_html = '<span class="rpx-footer-brand__text">' . esc_html( $site_name ) . '</span>';
}

$wrapper_attributes = get_block_wrapper_attributes(
	array(
		'class' => 'rpx-footer-brand',
	)
);
?>
<div <?php echo wp_kses_data( $wrapper_attributes ); ?>>
	<a class="rpx-footer-brand__link" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
		<?php echo wp_kses_post( $logo_html ); ?>
	</a>
</div>
