<?php
/**
 * Render callback for Hero Slider block.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-hero-slider' );
	ravenpine_enqueue_runtime_script( 'ravenpine-scroll-reveal' );
}

$slides_query = new WP_Query(
	array(
		'post_type'      => 'rpx_slide',
		'post_status'    => 'publish',
		'posts_per_page' => -1,
		'orderby'        => array(
			'menu_order' => 'ASC',
			'date'       => 'DESC',
		),
		'no_found_rows'          => true,
		'update_post_term_cache' => false,
		'ignore_sticky_posts'    => true,
	)
);

$hero_heading      = get_theme_mod( 'ravenpine_hero_heading', ravenpine_theme_mod_default( 'ravenpine_hero_heading' ) );
$hero_text         = get_theme_mod( 'ravenpine_hero_text', ravenpine_theme_mod_default( 'ravenpine_hero_text' ) );
$hero_button_label = get_theme_mod( 'ravenpine_hero_button_label', ravenpine_theme_mod_default( 'ravenpine_hero_button_label' ) );
$hero_button_url   = get_theme_mod( 'ravenpine_hero_button_url', ravenpine_theme_mod_default( 'ravenpine_hero_button_url' ) );
$hero_cards        = (bool) get_theme_mod( 'ravenpine_hero_cards_enabled', ravenpine_theme_mod_default( 'ravenpine_hero_cards_enabled' ) );
$hero_slider_controls = (bool) get_theme_mod( 'ravenpine_hero_slider_controls_enabled', ravenpine_theme_mod_default( 'ravenpine_hero_slider_controls_enabled' ) );
$hero_slider_effect = get_theme_mod( 'ravenpine_hero_slider_effect', ravenpine_theme_mod_default( 'ravenpine_hero_slider_effect' ) );
if ( function_exists( 'ravenpine_sanitize_hero_slider_effect' ) ) {
	$hero_slider_effect = ravenpine_sanitize_hero_slider_effect( $hero_slider_effect );
}
$hero_slider_duration = absint( get_theme_mod( 'ravenpine_hero_slider_duration', ravenpine_theme_mod_default( 'ravenpine_hero_slider_duration' ) ) );
$hero_slider_duration = min( max( $hero_slider_duration, 2 ), 30 );
$hero_slider_transition = absint( get_theme_mod( 'ravenpine_hero_slider_transition', ravenpine_theme_mod_default( 'ravenpine_hero_slider_transition' ) ) );
$hero_slider_transition = min( max( $hero_slider_transition, 150 ), 4000 );
$custom_logo_id    = get_theme_mod( 'custom_logo' );
$section_id        = ( isset( $attributes['anchor'] ) && ! empty( $attributes['anchor'] ) ) ? sanitize_title( $attributes['anchor'] ) : 'home';
$slide_count       = max( 1, (int) $slides_query->post_count );
$hero_slider_script_url = get_template_directory_uri() . '/assets/js/hero-slider.js';
if ( function_exists( 'ravenpine_asset_version' ) ) {
	$hero_slider_script_url = add_query_arg( 'ver', rawurlencode( (string) ravenpine_asset_version( 'assets/js/hero-slider.js' ) ), $hero_slider_script_url );
}
if ( function_exists( 'ravenpine_force_https_url' ) ) {
	$hero_slider_script_url = ravenpine_force_https_url( $hero_slider_script_url );
}
$hero_slider_script_url = esc_url_raw( $hero_slider_script_url );
$hero_slider_script_json = wp_json_encode( $hero_slider_script_url );
$scroll_reveal_script_url = get_template_directory_uri() . '/assets/js/scroll-reveal.js';
if ( function_exists( 'ravenpine_asset_version' ) ) {
	$scroll_reveal_script_url = add_query_arg( 'ver', rawurlencode( (string) ravenpine_asset_version( 'assets/js/scroll-reveal.js' ) ), $scroll_reveal_script_url );
}
if ( function_exists( 'ravenpine_force_https_url' ) ) {
	$scroll_reveal_script_url = ravenpine_force_https_url( $scroll_reveal_script_url );
}
$scroll_reveal_script_url = esc_url_raw( $scroll_reveal_script_url );
$scroll_reveal_script_json = wp_json_encode( $scroll_reveal_script_url );

$wrapper_attributes = get_block_wrapper_attributes(
	array(
		'class' => 'rpx-section rpx-hero',
		'id'    => $section_id,
	)
);
?>
<section <?php echo wp_kses_data( $wrapper_attributes ); ?>>
	<div
		class="rpx-hero-slider"
		data-rpx-slider
		data-rpx-slider-effect="<?php echo esc_attr( $hero_slider_effect ); ?>"
		data-rpx-slider-duration="<?php echo esc_attr( (string) $hero_slider_duration ); ?>"
		data-rpx-slider-transition="<?php echo esc_attr( (string) $hero_slider_transition ); ?>"
	>
		<?php if ( $slides_query->have_posts() ) : ?>
			<?php
			$index = 0;
			while ( $slides_query->have_posts() ) :
				$slides_query->the_post();
				$image_url  = get_the_post_thumbnail_url( get_the_ID(), 'full' );
				$image_style = $image_url ? 'background-image: url(' . esc_url( $image_url ) . ');' : 'background: linear-gradient(135deg, #2f2118, #705140);';
				$caption    = get_the_excerpt();
				?>
				<article class="rpx-hero-slide<?php echo 0 === $index ? ' is-active' : ''; ?>" style="<?php echo esc_attr( $image_style ); ?>" aria-hidden="<?php echo 0 === $index ? 'false' : 'true'; ?>">
					<?php if ( ! empty( $caption ) ) : ?>
						<p class="rpx-hero-slide-caption"><?php echo esc_html( $caption ); ?></p>
					<?php endif; ?>
				</article>
				<?php
				++$index;
			endwhile;
			wp_reset_postdata();
			?>
		<?php else : ?>
			<article class="rpx-hero-slide is-active" style="background: linear-gradient(135deg, #2f2118, #705140);" aria-hidden="false"></article>
		<?php endif; ?>

		<div class="rpx-hero-overlay<?php echo ! $hero_cards ? ' has-no-cards' : ''; ?>">
			<div class="rpx-hero-overlay__logo">
				<?php if ( $custom_logo_id ) : ?>
					<?php echo wp_get_attachment_image( $custom_logo_id, 'full', false, array( 'class' => 'rpx-hero-logo' ) ); ?>
				<?php else : ?>
					<div class="rpx-hero-logo--fallback"><?php bloginfo( 'name' ); ?></div>
				<?php endif; ?>
			</div>
			<div class="rpx-hero-overlay__content">
				<h1><?php echo esc_html( $hero_heading ); ?></h1>
				<p><?php echo esc_html( $hero_text ); ?></p>
				<?php if ( ! empty( $hero_button_label ) && ! empty( $hero_button_url ) ) : ?>
					<a class="rpx-button rpx-button--hero" style="font-family:var(--rpx-font-body) !important;font-style:normal;color:var(--rpx-hero-button-text) !important;background:var(--rpx-hero-button-bg) !important;" href="<?php echo esc_url( $hero_button_url ); ?>"><?php echo esc_html( $hero_button_label ); ?></a>
				<?php endif; ?>
			</div>
		</div>

		<?php if ( $hero_slider_controls && $slide_count > 1 ) : ?>
			<button class="rpx-slider-control rpx-slider-control--prev" type="button" data-rpx-prev aria-label="<?php esc_attr_e( 'Previous slide', 'ravenpine' ); ?>">&#10094;</button>
			<button class="rpx-slider-control rpx-slider-control--next" type="button" data-rpx-next aria-label="<?php esc_attr_e( 'Next slide', 'ravenpine' ); ?>">&#10095;</button>
		<?php endif; ?>
	</div>
	<script>
		(function () {
			if (window.__rpxThemeRuntimeLoader) {
				return;
			}
			window.__rpxThemeRuntimeLoader = true;

			function loadIfMissing(match, src) {
				if (!src || document.querySelector('script[src*="' + match + '"]')) {
					return;
				}

				var script = document.createElement('script');
				script.src = src;
				script.defer = true;
				document.head.appendChild(script);
			}

			loadIfMissing('/assets/js/hero-slider.js', <?php echo $hero_slider_script_json ? $hero_slider_script_json : '""'; ?>);
			loadIfMissing('/assets/js/scroll-reveal.js', <?php echo $scroll_reveal_script_json ? $scroll_reveal_script_json : '""'; ?>);
		})();
	</script>
</section>
