<?php
/**
 * Render callback for Location & Hours block.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-scroll-reveal' );
}

$settings = function_exists( 'ravenpine_get_restaurant_settings' ) ? ravenpine_get_restaurant_settings() : array();
$address  = isset( $settings['address'] ) ? $settings['address'] : '';
$phone    = isset( $settings['phone'] ) ? $settings['phone'] : '';
$email    = isset( $settings['email'] ) ? $settings['email'] : '';
$map_url  = isset( $settings['map_embed_url'] ) ? $settings['map_embed_url'] : '';

if ( empty( $map_url ) && ! empty( $address ) ) {
	$map_url = 'https://www.google.com/maps?q=' . rawurlencode( $address ) . '&output=embed';
}

$hours_groups = array(
	array(
		'label' => __( 'Breakfast', 'ravenpine' ),
		'rows'  => array(
			$settings['breakfast_hours'] ?? '',
		),
	),
	array(
		'label' => __( 'Lunch & Dinner', 'ravenpine' ),
		'rows'  => array(
			$settings['lunch_dinner_hours_line_one'] ?? '',
			$settings['lunch_dinner_hours_line_two'] ?? '',
		),
	),
	array(
		'label' => __( 'Happy Hour', 'ravenpine' ),
		'rows'  => array(
			$settings['happy_hour_line_one'] ?? '',
			$settings['happy_hour_line_two'] ?? '',
		),
	),
);

$phone_link = preg_replace( '/[^0-9+]/', '', $phone );
$email_link = sanitize_email( $email );

$wrapper_attributes = get_block_wrapper_attributes(
	array(
		'class' => 'rpx-section rpx-location-hours',
	)
);
?>
<section <?php echo wp_kses_data( $wrapper_attributes ); ?> id="location-hours">
	<div class="rpx-section-inner rpx-location-grid">
		<div class="rpx-location-copy">
			<p class="rpx-eyebrow"><?php esc_html_e( 'Visit Us', 'ravenpine' ); ?></p>
			<h2><?php esc_html_e( 'Location & Hours', 'ravenpine' ); ?></h2>
			<?php if ( ! empty( $address ) ) : ?>
				<p class="rpx-location-line"><strong><?php esc_html_e( 'Address:', 'ravenpine' ); ?></strong><br /><?php echo nl2br( esc_html( $address ) ); ?></p>
			<?php endif; ?>
			<?php if ( ! empty( $phone ) || ! empty( $email_link ) ) : ?>
				<p class="rpx-location-line rpx-contact-line">
					<?php if ( ! empty( $phone ) ) : ?>
						<span>
							<strong><?php esc_html_e( 'Phone:', 'ravenpine' ); ?></strong>
							<a class="rpx-phone-link" href="tel:<?php echo esc_attr( $phone_link ); ?>"><?php echo esc_html( $phone ); ?></a>
						</span>
					<?php endif; ?>
					<?php if ( ! empty( $phone ) && ! empty( $email_link ) ) : ?>
						<span class="rpx-contact-separator" aria-hidden="true">|</span>
					<?php endif; ?>
					<?php if ( ! empty( $email_link ) ) : ?>
						<span>
							<strong><?php esc_html_e( 'Email:', 'ravenpine' ); ?></strong>
							<a class="rpx-email-link" href="mailto:<?php echo esc_attr( $email_link ); ?>"><?php echo esc_html( $email_link ); ?></a>
						</span>
					<?php endif; ?>
				</p>
			<?php endif; ?>

			<div class="rpx-hours-list">
				<?php foreach ( $hours_groups as $group ) : ?>
					<?php
					$rows = array_values(
						array_filter(
							$group['rows'],
							static function( $value ) {
								return '' !== trim( (string) $value );
							}
						)
					);
					?>
					<?php if ( empty( $rows ) ) : ?>
						<?php continue; ?>
					<?php endif; ?>
					<div class="rpx-hours-group">
						<p class="rpx-hours-group-title"><?php echo esc_html( $group['label'] ); ?>:</p>
						<?php foreach ( $rows as $row ) : ?>
							<p class="rpx-hours-row"><?php echo esc_html( $row ); ?></p>
						<?php endforeach; ?>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
		<div class="rpx-location-map">
			<?php if ( ! empty( $map_url ) ) : ?>
				<iframe title="<?php esc_attr_e( 'Google Map', 'ravenpine' ); ?>" src="<?php echo esc_url( $map_url ); ?>" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
			<?php else : ?>
				<p class="rpx-empty-state"><?php esc_html_e( 'Add address or map URL in Appearance > Restaurant Info.', 'ravenpine' ); ?></p>
			<?php endif; ?>
		</div>
	</div>
</section>
