<?php
/**
 * Render callback for Masonry Gallery block.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-gallery-lightbox' );
	ravenpine_enqueue_runtime_script( 'ravenpine-scroll-reveal' );
}

$randomize    = (bool) get_theme_mod( 'ravenpine_gallery_randomize', ravenpine_theme_mod_default( 'ravenpine_gallery_randomize' ) );
$use_carousel = (bool) get_theme_mod( 'ravenpine_gallery_use_carousel', ravenpine_theme_mod_default( 'ravenpine_gallery_use_carousel' ) );

if ( $use_carousel && function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-gallery-carousel' );
}

$items = array();
$gallery_ids = function_exists( 'ravenpine_get_gallery_image_ids' ) ? ravenpine_get_gallery_image_ids() : array();

if ( $randomize && count( $gallery_ids ) > 1 ) {
	shuffle( $gallery_ids );
}

if ( ! empty( $gallery_ids ) ) {
	foreach ( $gallery_ids as $image_id ) {
		$full_url  = wp_get_attachment_image_url( $image_id, 'full' );
		$thumb_url = wp_get_attachment_image_url( $image_id, 'large' );
		if ( empty( $full_url ) ) {
			continue;
		}

		$alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
		if ( empty( $alt ) ) {
			$alt = get_the_title( $image_id );
		}

		$items[] = array(
			'full'  => $full_url,
			'thumb' => $thumb_url ? $thumb_url : $full_url,
			'alt'   => $alt,
		);
	}
}

if ( empty( $items ) ) {
	return;
}

$eyebrow    = get_theme_mod( 'ravenpine_gallery_section_eyebrow', ravenpine_theme_mod_default( 'ravenpine_gallery_section_eyebrow' ) );
$heading    = get_theme_mod( 'ravenpine_gallery_section_heading', ravenpine_theme_mod_default( 'ravenpine_gallery_section_heading' ) );
$section_id = ( isset( $attributes['anchor'] ) && ! empty( $attributes['anchor'] ) ) ? sanitize_title( $attributes['anchor'] ) : 'gallery';
$carousel_id = $use_carousel ? wp_unique_id( 'rpx-gallery-carousel-' ) : '';

$section_classes = 'rpx-section rpx-gallery-section';
if ( $use_carousel ) {
	$section_classes .= ' is-carousel';
}

$wrapper_attributes = get_block_wrapper_attributes(
	array(
		'class' => $section_classes,
		'id'    => $section_id,
	)
);
?>
<section <?php echo wp_kses_data( $wrapper_attributes ); ?>>
	<div class="rpx-section-inner">
		<?php if ( ! empty( $eyebrow ) || ! empty( $heading ) ) : ?>
			<div class="rpx-section-heading">
				<?php if ( ! empty( $eyebrow ) ) : ?>
					<p class="rpx-eyebrow"><?php echo esc_html( $eyebrow ); ?></p>
				<?php endif; ?>
				<?php if ( ! empty( $heading ) ) : ?>
					<h2><?php echo esc_html( $heading ); ?></h2>
				<?php endif; ?>
			</div>
		<?php endif; ?>

	<?php if ( $use_carousel ) : ?>
		<div class="rpx-gallery-carousel-controls" data-rpx-carousel-controls>
			<button type="button" class="rpx-gallery-carousel-control rpx-gallery-carousel-control--prev" data-rpx-carousel-prev aria-label="<?php esc_attr_e( 'Previous gallery images', 'ravenpine' ); ?>" aria-controls="<?php echo esc_attr( $carousel_id ); ?>">&larr;</button>
			<button type="button" class="rpx-gallery-carousel-control rpx-gallery-carousel-control--next" data-rpx-carousel-next aria-label="<?php esc_attr_e( 'Next gallery images', 'ravenpine' ); ?>" aria-controls="<?php echo esc_attr( $carousel_id ); ?>">&rarr;</button>
		</div>
	<?php endif; ?>

		<div class="rpx-gallery-grid <?php echo esc_attr( $use_carousel ? 'rpx-gallery-grid--carousel' : '' ); ?>" data-rpx-gallery-grid<?php echo $use_carousel ? ' data-rpx-gallery-carousel data-rpx-carousel-autoplay="true" id="' . esc_attr( $carousel_id ) . '"' : ''; ?>>
			<?php foreach ( $items as $index => $item ) : ?>
				<button type="button" class="rpx-masonry-item" data-rpx-lightbox-item data-rpx-full="<?php echo esc_url( $item['full'] ); ?>" data-rpx-index="<?php echo esc_attr( (string) $index ); ?>">
					<img src="<?php echo esc_url( $item['thumb'] ); ?>" alt="<?php echo esc_attr( $item['alt'] ); ?>" loading="lazy" />
				</button>
			<?php endforeach; ?>
		</div>
	</div>
</section>
