<?php
/**
 * Render callback for Menu Buttons block.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-scroll-reveal' );
}

$menu_query = new WP_Query(
	array(
		'post_type'      => 'rpx_menu',
		'post_status'    => 'publish',
		'posts_per_page' => -1,
		'orderby'        => array(
			'menu_order' => 'ASC',
			'date'       => 'ASC',
		),
		'no_found_rows'          => true,
		'update_post_term_cache' => false,
		'ignore_sticky_posts'    => true,
	)
);

$menu_eyebrow   = get_theme_mod( 'ravenpine_menu_section_eyebrow', ravenpine_theme_mod_default( 'ravenpine_menu_section_eyebrow' ) );
$menu_heading   = get_theme_mod( 'ravenpine_menu_section_heading', ravenpine_theme_mod_default( 'ravenpine_menu_section_heading' ) );
$menu_alignment = get_theme_mod( 'ravenpine_menu_section_alignment', ravenpine_theme_mod_default( 'ravenpine_menu_section_alignment' ) );
$menu_alignment = in_array( $menu_alignment, array( 'left', 'center', 'right' ), true ) ? $menu_alignment : 'left';

$wrapper_attributes = get_block_wrapper_attributes(
	array(
		'class' => 'rpx-section rpx-menu-buttons is-align-' . $menu_alignment,
	)
);
?>
<section <?php echo wp_kses_data( $wrapper_attributes ); ?> id="menus">
	<div class="rpx-section-inner">
		<?php if ( ! empty( $menu_eyebrow ) || ! empty( $menu_heading ) ) : ?>
			<div class="rpx-section-heading">
				<?php if ( ! empty( $menu_eyebrow ) ) : ?>
					<p class="rpx-eyebrow"><?php echo esc_html( $menu_eyebrow ); ?></p>
				<?php endif; ?>
				<?php if ( ! empty( $menu_heading ) ) : ?>
					<h2><?php echo esc_html( $menu_heading ); ?></h2>
				<?php endif; ?>
			</div>
		<?php endif; ?>
		<?php if ( $menu_query->have_posts() ) : ?>
			<div class="rpx-menu-grid">
				<?php
				while ( $menu_query->have_posts() ) :
					$menu_query->the_post();
					$menu_url = get_post_meta( get_the_ID(), '_ravenpine_menu_url', true );
					$menu_url = $menu_url ? $menu_url : '#';
					?>
					<a class="rpx-button rpx-button--menu" href="<?php echo esc_url( $menu_url ); ?>" target="_blank" rel="noopener noreferrer">
						<?php the_title(); ?>
					</a>
					<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		<?php else : ?>
			<p class="rpx-empty-state"><?php esc_html_e( 'Add items under Restaurant Menus in admin to populate these buttons.', 'ravenpine' ); ?></p>
		<?php endif; ?>
	</div>
</section>
