<?php
/**
 * Render callback for Optional Additional Info block.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-scroll-reveal' );
}

$settings = function_exists( 'ravenpine_get_restaurant_settings' ) ? ravenpine_get_restaurant_settings() : array();
$content  = isset( $settings['additional_info'] ) ? trim( (string) $settings['additional_info'] ) : '';

if ( '' === $content ) {
	return;
}

$formatted_content = wpautop( $content );

$wrapper_attributes = get_block_wrapper_attributes(
	array(
		'class' => 'rpx-optional-additional-info',
	)
);
?>
<div <?php echo wp_kses_data( $wrapper_attributes ); ?>>
	<?php echo wp_kses_post( $formatted_content ); ?>
</div>
