<?php
/**
 * Render callback for Optional Tagline block.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-scroll-reveal' );
}

$tagline = trim( (string) get_bloginfo( 'description' ) );
if ( '' === $tagline ) {
	return;
}

$wrapper_attributes = get_block_wrapper_attributes(
	array(
		'class' => 'rpx-optional-tagline',
	)
);
?>
<p <?php echo wp_kses_data( $wrapper_attributes ); ?>><?php echo esc_html( $tagline ); ?></p>
