<?php
/**
 * Render callback for Social Links block.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( function_exists( 'ravenpine_enqueue_runtime_script' ) ) {
	ravenpine_enqueue_runtime_script( 'ravenpine-scroll-reveal' );
}

$links = function_exists( 'ravenpine_get_social_links' ) ? ravenpine_get_social_links() : array();

if ( empty( $links ) ) {
	return;
}

$wrapper_attributes = get_block_wrapper_attributes(
	array(
		'class' => 'rpx-section rpx-social-links',
	)
);
?>
<section <?php echo wp_kses_data( $wrapper_attributes ); ?> id="social-links">
	<div class="rpx-section-inner">
		<ul class="rpx-social-list">
			<?php foreach ( $links as $label => $url ) : ?>
				<li>
					<a href="<?php echo esc_url( $url ); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html( $label ); ?></a>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
</section>
