<?php
/**
 * Block registration and helpers.
 *
 * @package Ravenpine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Register custom dynamic blocks.
 */
function ravenpine_register_blocks() {
	$block_json_files = glob( get_template_directory() . '/blocks/*/block.json' );
	if ( empty( $block_json_files ) ) {
		return;
	}

	foreach ( $block_json_files as $block_json ) {
		register_block_type( dirname( $block_json ) );
	}
}
add_action( 'init', 'ravenpine_register_blocks' );

/**
 * Add custom category for theme blocks.
 *
 * @param array $categories Existing categories.
 * @return array
 */
function ravenpine_block_categories( $categories ) {
	$categories[] = array(
		'slug'  => 'ravenpine',
		'title' => __( 'Ravenpine Theme', 'ravenpine' ),
	);
	return $categories;
}
add_filter( 'block_categories_all', 'ravenpine_block_categories' );

/**
 * Get active social links.
 *
 * @return array
 */
function ravenpine_get_social_links() {
	$links = array(
		'Facebook'  => get_theme_mod( 'ravenpine_social_facebook', '' ),
		'Instagram' => get_theme_mod( 'ravenpine_social_instagram', '' ),
		'X'         => get_theme_mod( 'ravenpine_social_x', '' ),
		'TikTok'    => get_theme_mod( 'ravenpine_social_tiktok', '' ),
		'Yelp'      => get_theme_mod( 'ravenpine_social_yelp', '' ),
	);

	return array_filter(
		array_map( 'esc_url', $links )
	);
}
