# WP Unconfirmed Users

Shows pending/unconfirmed invitations directly in WordPress user list screens and provides admin actions so you do not need manual database edits.

## Features

- Adds an `Unconfirmed` filter/view to:
  - Site admin `Users`
  - Network admin `Users`
  - Network admin `Site Users`
- Lists pending invitations from the multisite `signups` table.
- Actions available per invitation:
  - Resend invite email
  - Activate now
  - Delete invitation
- Bulk actions supported in unconfirmed view.
- Safe behavior on single-site installs (view appears, list stays empty because core does not track pending invitations there).

## Install

1. Place this plugin folder in `wp-content/plugins/wpunconfirmed`.
2. Activate **WP Unconfirmed Users** in the WordPress admin.

## Use

1. Go to `Users`.
2. Click the `Unconfirmed` view link.
3. Manage pending invitations from row actions or bulk actions.

## Notes

- This plugin is designed around WordPress core multisite invitation records (`wp_signups`).
- The “Activate” action includes a fallback for signups that error with `user_already_exists` and can still complete assignment to the target site.
